/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.controllers.data.Availability;

public class WrapperRecipe {
    public boolean global = true;
    public boolean known = false;
    public boolean ignoreDamage = false;
    public boolean ignoreNBT = false;
    public boolean isShaped = true;
    public boolean main = false;
    public int id = -1;
    public int width = 3;
    public int height = 3;
    public String group = "";
    public String name = "";
    public String domen = "minecraft";
    public final Map<Integer, ItemStack[]> recipeItems = new TreeMap<Integer, ItemStack[]>();
    public ItemStack product = new ItemStack(Blocks.field_150347_e);
    public final Availability availability = new Availability();
    public IRecipe parent = null;

    public WrapperRecipe() {
        this.recipeItems.clear();
        this.recipeItems.put(0, new ItemStack[]{new ItemStack(Blocks.field_150347_e)});
    }

    public void clear() {
        this.known = false;
        this.ignoreDamage = false;
        this.ignoreNBT = false;
        this.isShaped = true;
        this.id = -1;
        this.width = 3;
        this.height = 3;
        this.group = "";
        this.name = "";
        this.recipeItems.clear();
        this.recipeItems.put(0, new ItemStack[]{new ItemStack(Blocks.field_150347_e)});
        this.product = new ItemStack(Blocks.field_150347_e);
        this.availability.clear();
        this.main = false;
    }

    public NBTTagCompound getNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Width", this.width);
        compound.func_74768_a("Height", this.height);
        if (this.product != null) {
            compound.func_74782_a("Item", (NBTBase)this.product.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int slot = 0; slot < (this.global ? 9 : 16); ++slot) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            NBTTagList ingredients = new NBTTagList();
            if (this.recipeItems.get(slot) != null) {
                for (ItemStack ing : this.recipeItems.get(slot)) {
                    ingredients.func_74742_a((NBTBase)ing.func_77955_b(new NBTTagCompound()));
                }
            }
            nbttagcompound.func_74782_a("Ingredients", (NBTBase)ingredients);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Materials", (NBTBase)nbttaglist);
        compound.func_74782_a("Availability", (NBTBase)this.availability.save(new NBTTagCompound()));
        compound.func_74778_a("Name", this.name);
        compound.func_74778_a("Domen", this.domen);
        compound.func_74757_a("Global", this.global);
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        compound.func_74778_a("Group", this.group);
        compound.func_74757_a("IsKnown", this.known);
        compound.func_74757_a("IsShaped", this.isShaped);
        return compound;
    }

    public boolean isValid() {
        boolean hasStack = false;
        for (ItemStack[] array : this.recipeItems.values()) {
            if (array == null) continue;
            for (ItemStack stack : array) {
                if (stack == null || stack.func_190926_b()) continue;
                hasStack = true;
                break;
            }
            if (!hasStack) continue;
            break;
        }
        return hasStack && (this.domen.equals("minecraft") || !this.group.isEmpty() && !this.name.isEmpty());
    }

    public void copyFrom(WrapperRecipe wrapper) {
        this.global = wrapper.global;
        this.known = wrapper.known;
        this.ignoreDamage = wrapper.ignoreDamage;
        this.ignoreNBT = wrapper.ignoreNBT;
        this.isShaped = wrapper.isShaped;
        this.main = wrapper.main;
        this.id = wrapper.id;
        this.width = wrapper.width;
        this.height = wrapper.height;
        this.group = wrapper.group;
        this.name = wrapper.name;
        this.domen = wrapper.domen;
        this.recipeItems.clear();
        this.recipeItems.putAll(wrapper.recipeItems);
        this.product = wrapper.product;
        this.availability.load(wrapper.availability.save(new NBTTagCompound()));
        this.parent = wrapper.parent;
    }

    public void copyFrom(IRecipe recipe, int recipeId) {
        if (recipe instanceof INpcRecipe) {
            this.copyFrom(((INpcRecipe)recipe).getWrapperRecipe());
            this.id = recipeId;
            return;
        }
        this.clear();
        ResourceLocation location = recipe.getRegistryName();
        if (location == null) {
            location = new ResourceLocation("default");
        }
        this.parent = recipe;
        this.global = true;
        this.known = false;
        this.ignoreDamage = false;
        this.ignoreNBT = false;
        this.isShaped = recipe instanceof ShapedRecipes;
        this.main = true;
        this.id = recipeId;
        int pos = 0;
        NonNullList ingredients = recipe.func_192400_c();
        if (recipe instanceof IShapedRecipe) {
            this.width = ((IShapedRecipe)recipe).getRecipeWidth();
            this.height = ((IShapedRecipe)recipe).getRecipeHeight();
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int index = y * this.width + x;
                    ItemStack[] rawMatchingStacks = ((Ingredient)ingredients.get(index)).func_193365_a();
                    ItemStack[] array = new ItemStack[rawMatchingStacks.length];
                    for (int j = 0; j < rawMatchingStacks.length; ++j) {
                        array[j] = rawMatchingStacks[j].func_77946_l();
                    }
                    int slotIndex = y * 3 + x;
                    this.recipeItems.put(slotIndex, array);
                }
            }
            for (int i = 0; i < 9; ++i) {
                if (this.recipeItems.containsKey(i)) continue;
                this.recipeItems.put(i, new ItemStack[0]);
            }
        } else {
            for (Ingredient ingr : ingredients) {
                ItemStack[] rawMatchingStacks = ingr.func_193365_a();
                ItemStack[] array = new ItemStack[rawMatchingStacks.length];
                for (int j = 0; j < rawMatchingStacks.length; ++j) {
                    array[j] = rawMatchingStacks[j].func_77946_l();
                }
                this.recipeItems.put(pos, array);
                ++pos;
            }
        }
        this.width = 3;
        this.height = 3;
        this.group = "\u00a77" + recipe.func_193358_e();
        this.name = "\u00a77" + location.func_110623_a();
        this.product = recipe.func_77571_b();
        this.availability.clear();
        if (this.product != null && !this.product.func_190926_b() && this.product.func_77973_b().getRegistryName() != null) {
            this.domen = this.product.func_77973_b().getRegistryName().func_110624_b();
        }
    }

    public String getName() {
        return this.name;
    }
}

